/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Audio.AudioPlayer;
import Entity.PlayerSave;
import GameState.CreditsState;
import GameState.DifficultyState;
import GameState.GameOverState;
import GameState.GameState;
import GameState.HighScoresState;
import GameState.HowToPlayState;
import GameState.IntroState;
import GameState.MenuState;
import GameState.OptionsState;
import GameState.PlayState;
import Handlers.Options;
import Main.GamePanel;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class GameStateManager {
    private Background bg1 = new Background("/Backgrounds/starBG.png", 1.0);
    private GameState[] gameStates;
    private int currentState;
    private Font font;
    public Font regFont;
    public static boolean firstTime = false;
    public static final int NUMGAMESTATES = 9;
    public static final int MENUSTATE = 0;
    public static final int PLAYSTATE = 1;
    public static final int GAMEOVERSTATE = 2;
    public static final int DIFFICULTYSTATE = 3;
    public static final int HIGHSCORESTATE = 4;
    public static final int HOWTOPLAYSTATE = 5;
    public static final int OPTIONSSTATE = 6;
    public static final int CREDITSSTATE = 7;
    public static final int INTROSTATE = 8;

    public GameStateManager() throws IOException {
        this.bg1.setVector(-0.5, 0.0);
        this.font = new Font("Arial", 0, 22);
        try {
            this.regFont = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Squares_Bold_Free.otf")).deriveFont(24.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Squares_Bold_Free.otf")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        this.createCreditsFile();
        AudioPlayer.init();
        Options.init();
        PlayerSave.getHighScores();
        AudioPlayer.load("/Music/intro.mp3", "introMusic");
        AudioPlayer.load("/SFX/MouseClick.mp3", "click");
        this.gameStates = new GameState[9];
        this.currentState = 8;
        this.loadState(this.currentState);
    }

    private void loadState(int state) {
        if (state == 0) {
            this.gameStates[state] = new MenuState(this);
        }
        if (state == 1) {
            this.gameStates[state] = new PlayState(this);
        }
        if (state == 2) {
            this.gameStates[state] = new GameOverState(this);
        }
        if (state == 3) {
            this.gameStates[state] = new DifficultyState(this);
        }
        if (state == 4) {
            this.gameStates[state] = new HighScoresState(this);
        }
        if (state == 5) {
            this.gameStates[state] = new HowToPlayState(this);
        }
        if (state == 6) {
            this.gameStates[state] = new OptionsState(this);
        }
        if (state == 7) {
            this.gameStates[state] = new CreditsState(this);
        }
        if (state == 8) {
            this.gameStates[state] = new IntroState(this);
        }
    }

    private void unloadState(int state) {
        this.gameStates[state] = null;
    }

    public void setState(int state) {
        this.unloadState(this.currentState);
        this.currentState = state;
        this.loadState(this.currentState);
        this.gameStates[this.currentState].init();
    }

    public void update() {
        if (this.currentState != 8) {
            this.bg1.update();
        }
        if (this.gameStates[this.currentState] == null) {
            return;
        }
        this.gameStates[this.currentState].update();
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 800, 400);
        if (this.currentState != 8) {
            this.bg1.draw(g);
        }
        if (this.gameStates[this.currentState] == null) {
            return;
        }
        this.gameStates[this.currentState].draw(g);
        if (Options.getOption(2) && this.currentState != 8) {
            g.setColor(Color.white);
            g.setFont(this.font);
            g.drawString("FPS : " + GamePanel.getFPS(), 705, 25);
        }
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public void createCreditsFile() {
        boolean success = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender").mkdirs();
        File creditsFile = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender/Credits.txt");
        if (!creditsFile.exists()) {
            int length;
            String[] line;
            block32: {
                try {
                    System.out.println("No Credits File - Creating One");
                    creditsFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                InputStreamReader in = null;
                BufferedReader br = null;
                line = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
                length = 0;
                try {
                    try {
                        in = new InputStreamReader(GameStateManager.class.getResourceAsStream("/Credits.txt"));
                        br = new BufferedReader(in);
                        while ((line[length] = br.readLine()) != null) {
                            ++length;
                        }
                    }
                    catch (Exception exception) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                try {
                    fw = new FileWriter(creditsFile);
                    bw = new BufferedWriter(fw);
                    int i = 0;
                    while (i < length) {
                        bw.write(line[i]);
                        bw.newLine();
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("ERROR WRITING TO CREDITS FILE");
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

